% ------------------------------------------------------------------------
% Script: infile_2d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 2D P-N model
% ------------------------------------------------------------------------

    % System name
 
    system='2d P-N model';
 
    % The absolute path to save the result files
 
    filepath=pwd;
 
    % The dimension of P-N model: 1 or 2 

    misdim=2;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------ 
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
 
    % % the data of GSFE (unit: J/m2) and normalized disregistry vector (unit: 1)
    
    [Ux,Uz]=meshgrid(0:0.1:1,0:0.0666:1);
    SFE=[0	34.79179	90.4133	113.92514	112.49098	109.4397	129.93947	202.44626	289.0399	358.1367	383.75504	350.78488	273.55285	155.95833	39.87638	-5.89609;
31.87902	73.62276	128.27074	147.99168	137.7003	119.20967	125.2567	186.06081	268.51726	337.27822	360.59863	330.77449	257.0204	152.99722	56.34807	25.88884;
106.78632	163.28794	215.29104	224.7389	197.19243	149.23702	114.13815	143.8767	212.84217	280.87658	302.32767	278.57734	219.3152	137.77087	85.17254	102.07807;
178.34245	251.84956	300.38191	300.87651	258.97727	184.76582	107.65401	85.71877	127.79769	190.83832	220.04176	208.45996	168.98606	120.68304	117.78073	178.95662;
228.58926	304.89937	356.17068	356.40394	304.86343	212.36324	101.2718	31.52946	40.84796	103.03658	139.19458	141.85188	122.40927	110.53084	149.04231	232.55593;
242.25273	322.03358	375.75572	374.53717	322.64384	221.52297	97.80301	6.39266	3.53217	63.74955	101.39137	110.42891	103.07121	108.01141	160.66723	248.49511;
226.3351	302.13884	352.79663	352.27132	302.63541	210.75854	102.78046	32.28085	42.60816	106.7334	143.79568	144.77901	123.6043	112.26164	149.42062	229.89929;
173.5375	245.01195	295.01897	296.34468	255.30397	183.21861	107.66773	86.11733	132.41055	199.19765	227.16751	213.58245	172.15168	122.79542	119.80425	177.00759;
102.29108	157.41079	209.3002	219.112	192.99643	145.52779	111.16004	143.98646	218.88854	287.78672	307.51027	281.93375	221.33153	139.3821	84.30747	100.78046;
29.59807	69.77697	124.30538	144.747	133.74932	114.78826	120.34133	185.50805	270.73156	340.0381	361.55779	329.49321	256.46503	150.4216	54.63491	24.66964;
-1.48448	32.89699	87.50837	109.9147	108.33091	103.80626	125.50433	200.94871	289.0399	358.1367	383.75504	350.78488	269.98606	155.95833	39.87638	-7.4544]'/1E3;

    % % Which trial function of disregistry vector to employ (>=-1)
    
    Nmis=0;     
     
    % % The value of Burgers vector (unit: A)
 
    BurVect=2.659;
 
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=32.61;
    poisson_ratio=0.286;
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=-1)
    
    fitcut=0;
    
    % % Mode of P-N models: CCPN (1) or SVPN (2)

    pnmode=2;
    
    % % Interplanar distance ?x (unit: A)
    
    Inpas=1/2*BurVect;
    
    % % The reference position x_m is defined as x_m=m?x+dax for SVPN model
    %   (m=0, 1, 2, , ?)
 
    dax=0.0;
 
   % % Matrix of the lower and upper bounds, and initial values of each unknown 
   %   variable ([Lower bound, Upper bound, StartPoint]) 
  
    Xcoef_range=[0.00, 1.00, 0.200];
    Xdist_range=[-50.00, 50.00, 8.00];
    Xwid_range=[0.00,20.00, 1.00];
    dx_range=[-5.00,5.00, 0.00];
    
    % % The minimization method for 2D P-N model: PSO ('2d_PSO') or GA ('2d_GA')
 
    minimethod='2d_PSO';   
    
    % % PSO or GA Parameters
 
        % % % Size of the population and maximum number of iteration
 
        PopulationSize=100;
        MaxIterations=1000;
       
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
    
    % % Interplanar distance ?x (unit: A) 

    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
    
        % % % >>> For edge dislocation of FCC and HCP structures
 
        % LatC_spacing=sqrt(2/3)/2*BurVect;
        % [pressfld_latxz,pressfld_latyy]=meshgrid(-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect,...
        %                                -(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing);
 
        % % % >>> For screw dislocation of FCC structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+7/12)*BurVect:(1/2*BurVect):(6+11/12)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],10,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
        % % % >>> For screw dislocation of HCP structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],15,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
    % % Which component of the dislocation to calculate: x or z
    
    % dis_component_xz='x';
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of solid solution strengthening
% ------------------------------------------------------------------------
 
    % % Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
    
    Solution_Strengthening='FALSE';
    
    % % Plotting the position-dependent solute/dislocation interaction energy
    %   ('TRUE') or NOT ('FALSE')
    
    % Einteraction_Plot='TRUE';
    
    % % The input volumetric misfit (eb_input) and slip misfit (es_input) parameters
    
    % eb_input=[];
    % es_input=[];
 
    % % The interlayer spacing along FCC [111] or HCP [0001] direction
 
    % LatC_spacing=[];

        % % % >>> for FCC structure

        % LatC_spacing=sqrt(2/3)/2*BurVect; 
 
    % % The coefficient to calculate the extra volume (unit: A^3), i.e. dV=coefV*eb
    
    % coefV=[];

        % % % >>> for FCC structure
    
        % coefV=3/4*(sqrt(2)*BurVect)^3;

    % % Matrix of the lower and upper bounds to search the characteristic bow-out distance wc (unit: A)
    
    % wc_range=[];        
        
    % % Concentration of solute atom
 
    % solute_concentration=1;
